/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.net.URI;
import java.net.URL;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.table.DefaultTableModel;

public class RenamerGUI
extends JFrame {
    private static String version = "1.0";
    private static JMenuBar menuBar = new JMenuBar();
    private static JMenu fileMenu = new JMenu("File");
    private static JMenuItem fileMenuOpen = new JMenuItem("Open", 79);
    private static JMenuItem fileMenuExit = new JMenuItem("Exit", 88);
    private static JMenu editMenu = new JMenu("Edit");
    private static JMenuItem editMenuUndo = new JMenuItem("Undo (feature coming soon!)");
    private static JMenu editMenuLook = new JMenu("Theme");
    private static JMenuItem editMenuLook0 = new JMenuItem("Stormhyde", 83);
    private static JMenuItem editMenuLook1 = new JMenuItem("System Default", 68);
    private static JMenu helpMenu = new JMenu("Help");
    private static JMenuItem helpMenuAbout = new JMenuItem("About", 65);
    private static JMenuItem helpMenuWebsite = new JMenuItem("Update", 85);
    private static JMenuItem helpMenuDonate = new JMenuItem("Donate", 68);
    private static JMenuItem helpMenuForum = new JMenuItem("Forums", 70);
    private static URL bannerUrl = ClassLoader.getSystemResource("images/banner-ir.png");
    private static URL aboutUrl = ClassLoader.getSystemResource("images/stormhyde.png");
    private static URL logoUrl = ClassLoader.getSystemResource("images/logo.png");
    private static Image logoImage = Toolkit.getDefaultToolkit().createImage(logoUrl);
    private static ImageIcon bannerImage = new ImageIcon(bannerUrl);
    private static ImageIcon aboutImage = new ImageIcon(aboutUrl);
    private static URL openUrl = ClassLoader.getSystemResource("images/iconOpen.png");
    private static Icon iconOpen = new ImageIcon(openUrl);
    private static JLabel jlblBanner = new JLabel(bannerImage);
    private static JLabel jlblaboutImage = new JLabel(aboutImage);
    private static int padX = 10;
    private static int padY = 3;
    private static JPanel panelNorth = new JPanel(new BorderLayout());
    private static JPanel panelCenter = new JPanel(new GridLayout(7, 1));
    private static JPanel panelSouth = new JPanel(new BorderLayout());
    private static JPanel panelCenterRowA = new JPanel(new BorderLayout());
    private static JPanel panelCenterRow0 = new JPanel(new GridLayout(1, 4));
    private static JPanel panelCenterRow1 = new JPanel(new GridLayout(1, 4));
    private static JPanel panelCenterRow2 = new JPanel(new GridLayout(1, 2));
    private static JPanel panelCenterRow3 = new JPanel(new GridLayout(1, 4));
    private static JPanel panelCenterRow4 = new JPanel(new GridLayout(1, 4));
    private static JPanel panelCenterRow5 = new JPanel(new GridLayout(1, 1));
    private static JPanel panelCenterRow6 = new JPanel(new GridLayout(1, 2));
    private static JLabel jlblDirectory = new JLabel("Source Directory");
    private static JLabel jlblFileFilter = new JLabel("File filter");
    private static JLabel jlblNewName = new JLabel("Name");
    private static JLabel jlblPadding = new JLabel("Padding");
    private static JLabel jlblExtension = new JLabel("Extension");
    private static JLabel jlblStartNumber = new JLabel("Start at");
    private static JLabel jlblDot = new JLabel(".");
    private static JLabel jlblOrder = new JLabel("Order by");
    private static JTextField jtfDirectory = new JTextField();
    private static JTextField jtfFileFilter = new JTextField();
    private static JTextField jtfFileFilter2 = new JTextField();
    private static JTextField jtfNamePrefix = new JTextField();
    private static JTextField jtfNameExtension = new JTextField();
    private static JTextField jtfStartNumber = new JTextField();
    private static JButton jbtOpenDirectory = new JButton("");
    private static JButton jbtRename = new JButton("Rename");
    private static JComboBox jcbPadding;
    private static JComboBox jcbOrder;
    private static DefaultTableModel tableModel;
    private static customTable table;
    private static JScrollPane scrollPane;
    private static String[] tableColumns;
    private static JFrame frame;

    public static void main(String[] args) {
        frame = new RenamerGUI();
        frame.setTitle("Image Renamer v" + version + " - Stormhyde Software");
        frame.setSize(600, 550);
        frame.setMinimumSize(new Dimension(600, 550));
        frame.setLocationRelativeTo(null);
        frame.setDefaultCloseOperation(3);
        RenamerGUI.setLogo(frame);
        RenamerGUI.setLook(0);
        frame.setVisible(true);
        try {
            Runtime.getRuntime().exec("attrib -r \"%USERPROFILE%\\My Documents\"");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public RenamerGUI() {
        this.setJMenuBar(menuBar);
        fileMenu.add(fileMenuOpen);
        fileMenu.add(fileMenuExit);
        menuBar.add(fileMenu);
        editMenuLook.setMnemonic('T');
        editMenu.add(editMenuLook);
        editMenuLook.add(editMenuLook0);
        editMenuLook.add(editMenuLook1);
        menuBar.add(editMenu);
        helpMenu.add(helpMenuAbout);
        helpMenu.add(helpMenuWebsite);
        helpMenu.add(helpMenuDonate);
        helpMenu.add(helpMenuForum);
        menuBar.add(helpMenu);
        jbtOpenDirectory.setIcon(iconOpen);
        panelNorth.add(jlblBanner);
        panelNorth.setBackground(Color.BLACK);
        String[] paddingOptions = new String[]{" ", "00", "000", "0000", "00000"};
        jcbPadding = new JComboBox<String>(paddingOptions);
        jcbPadding.setSelectedIndex(0);
        String[] orderOptions = new String[]{"A to Z", "Date Last Modified"};
        jcbOrder = new JComboBox<String>(orderOptions);
        jcbOrder.setSelectedIndex(0);
        panelCenterRowA.add((Component)jlblDirectory, "West");
        panelCenterRowA.add((Component)jtfDirectory, "Center");
        panelCenterRowA.add((Component)jbtOpenDirectory, "East");
        panelCenter.add(panelCenterRowA);
        panelCenterRow0.add(jlblFileFilter);
        panelCenterRow0.add(jtfFileFilter);
        panelCenterRow0.add(jtfFileFilter2);
        panelCenterRow0.add(new JLabel(""));
        panelCenter.add(panelCenterRow0);
        panelCenterRow1.add(jlblOrder);
        panelCenterRow1.add(jcbOrder);
        panelCenterRow1.add(new JLabel(""));
        panelCenterRow1.add(new JLabel(""));
        panelCenter.add(panelCenterRow1);
        panelCenterRow2.add(jlblNewName);
        panelCenterRow2.add(jlblPadding);
        panelCenterRow2.add(new JLabel(""));
        panelCenterRow2.add(jlblExtension);
        panelCenter.add(panelCenterRow2);
        panelCenterRow3.add(jtfNamePrefix);
        panelCenterRow3.add(jcbPadding);
        panelCenterRow3.add(jlblDot);
        panelCenterRow3.add(jtfNameExtension);
        panelCenter.add(panelCenterRow3);
        panelCenterRow4.add(jlblStartNumber);
        panelCenterRow4.add(jtfStartNumber);
        panelCenterRow4.add(new JLabel(""));
        panelCenterRow4.add(new JLabel(""));
        panelCenter.add(panelCenterRow4);
        panelCenterRow5.add(jbtRename);
        panelCenter.add(panelCenterRow5);
        tableModel = new DefaultTableModel((Object[][])null, tableColumns);
        table = new customTable();
        table.setModel(tableModel);
        table.setFillsViewportHeight(true);
        table.setSelectionMode(0);
        table.setPreferredScrollableViewportSize(new Dimension(550, 100));
        table.getTableHeader().setReorderingAllowed(false);
        scrollPane = new JScrollPane(table);
        panelSouth.add(scrollPane);
        this.setLayout(new BorderLayout());
        this.add((Component)panelNorth, "North");
        this.add((Component)panelCenter, "Center");
        this.add((Component)panelSouth, "South");
        panelSouth.setPreferredSize(new Dimension(550, 250));
        panelSouth.setMinimumSize(new Dimension(550, 100));
        panelCenter.setPreferredSize(new Dimension(550, 250));
        panelCenter.setMinimumSize(new Dimension(550, 200));
        jlblDirectory.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        jlblFileFilter.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        jlblOrder.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        jlblNewName.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        jlblPadding.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        jlblDot.setHorizontalAlignment(0);
        jlblExtension.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        jlblStartNumber.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        jbtRename.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        ListenerOrder listenerOrder = new ListenerOrder();
        jcbOrder.addItemListener(listenerOrder);
        ListenerOpenDirectory listenerOpenDirectory = new ListenerOpenDirectory();
        jbtOpenDirectory.addActionListener(listenerOpenDirectory);
        fileMenuOpen.addActionListener(listenerOpenDirectory);
        ListenerRename listenerRename = new ListenerRename();
        jbtRename.addActionListener(listenerRename);
        ListenerChangeDirectory listenerChangeDirectory = new ListenerChangeDirectory();
        jtfDirectory.getDocument().addDocumentListener(listenerChangeDirectory);
        jtfFileFilter.getDocument().addDocumentListener(listenerChangeDirectory);
        jtfFileFilter2.getDocument().addDocumentListener(listenerChangeDirectory);
        jtfNamePrefix.getDocument().addDocumentListener(listenerChangeDirectory);
        jtfNameExtension.getDocument().addDocumentListener(listenerChangeDirectory);
        jtfStartNumber.getDocument().addDocumentListener(listenerChangeDirectory);
        jcbPadding.addItemListener(listenerOrder);
        ListenerFileExit listenerFileExit = new ListenerFileExit();
        fileMenuExit.addActionListener(listenerFileExit);
        ListenerEditUndo listenerEditUndo = new ListenerEditUndo();
        editMenuUndo.addActionListener(listenerEditUndo);
        ListenerEditLook0 listenerEditLook0 = new ListenerEditLook0();
        editMenuLook0.addActionListener(listenerEditLook0);
        ListenerEditLook1 listenerEditLook1 = new ListenerEditLook1();
        editMenuLook1.addActionListener(listenerEditLook1);
        ListenerHelpAbout listenerHelpAbout = new ListenerHelpAbout();
        helpMenuAbout.addActionListener(listenerHelpAbout);
        ListenerHelpWebsite listenerHelpWebsite = new ListenerHelpWebsite();
        helpMenuWebsite.addActionListener(listenerHelpWebsite);
        ListenerHelpDonate listenerHelpDonate = new ListenerHelpDonate();
        helpMenuDonate.addActionListener(listenerHelpDonate);
        ListenerHelpForum listenerHelpForum = new ListenerHelpForum();
        helpMenuForum.addActionListener(listenerHelpForum);
    }

    public static void loadFiles() {
        int i;
        Object[] listOfFiles;
        File folder = new File(jtfDirectory.getText());
        String[] children = folder.list();
        if (children == null) {
            listOfFiles = new File[]{};
        } else {
            listOfFiles = new File[children.length];
            for (int i2 = 0; i2 < children.length; ++i2) {
                listOfFiles[i2] = new File(folder.toString() + "\\" + children[i2]);
            }
        }
        int mode = jcbOrder.getSelectedIndex();
        if (mode == 1) {
            Arrays.sort(listOfFiles, new Comparator2());
        } else if (mode == 2) {
            Arrays.sort(listOfFiles, new Comparator1());
        } else {
            Arrays.sort(listOfFiles);
        }
        int rowCount = tableModel.getRowCount();
        if (rowCount != 0) {
            for (i = 0; i < rowCount; ++i) {
                tableModel.removeRow(0);
            }
        }
        if (listOfFiles != null) {
            i = 0;
            for (int x = 0; x < listOfFiles.length; ++x) {
                if (!RenamerGUI.includeFile(((File)listOfFiles[x]).getName()).booleanValue()) continue;
                String fileName = ((File)listOfFiles[x]).getName();
                String newName = RenamerGUI.getNewName(fileName, ++i);
                RenamerGUI.addFile(fileName, newName);
            }
        }
    }

    public static void addFile(String fileName, String newName) {
        Vector<String> data = new Vector<String>(2);
        data.addElement(fileName);
        data.addElement(newName);
        tableModel.addRow(data);
    }

    public static Boolean includeFile(String fileName) {
        String filter = jtfFileFilter.getText();
        String filter2 = jtfFileFilter2.getText();
        boolean match1 = true;
        boolean match2 = true;
        if (!filter.equals("")) {
            match1 = fileName.matches("(?i).*" + filter + ".*");
        }
        if (!filter2.equals("")) {
            match2 = fileName.matches("(?i).*" + filter2 + ".*");
        }
        if (match1 && match2) {
            return true;
        }
        return false;
    }

    public static String getNewName(String fileName, int i) {
        String ext;
        int dot;
        if (fileName.contains(".")) {
            dot = fileName.lastIndexOf(".");
            ext = fileName.substring(dot + 1);
        } else {
            dot = fileName.length();
            ext = "";
        }
        String name = fileName.substring(0, dot);
        String prefix = jtfNamePrefix.getText().equals("") ? fileName.substring(0, dot) : jtfNamePrefix.getText();
        int paddingSelected = jcbPadding.getSelectedIndex();
        String padding = "";
        if (paddingSelected != 0) {
            if (jtfStartNumber.getText().equals("") || jtfStartNumber.getText().equals(" ")) {
                int iLength = Integer.toString(i).length();
                padding = (String)jcbPadding.getSelectedItem();
                padding = padding.substring(0, padding.length() - iLength);
                padding = padding + Integer.toString(i);
            } else if (RenamerGUI.startNumberIsInt().booleanValue()) {
                i = i + Integer.parseInt(jtfStartNumber.getText()) - 1;
                int iLength = Integer.toString(i).length();
                padding = (String)jcbPadding.getSelectedItem();
                padding = padding.substring(0, padding.length() - iLength);
                padding = padding + Integer.toString(i);
            } else {
                int iLength = Integer.toString(i).length();
                padding = (String)jcbPadding.getSelectedItem();
                padding = padding.substring(0, padding.length() - iLength);
                padding = padding + Integer.toString(i);
            }
        }
        String newExt = !jtfNameExtension.getText().equals("") ? jtfNameExtension.getText() : ext;
        String newName = prefix + padding + "." + newExt;
        return newName;
    }

    private static Boolean startNumberIsInt() {
        try {
            int i = Integer.parseInt(jtfStartNumber.getText());
            return true;
        }
        catch (Exception ex) {
            return false;
        }
    }

    public static void setLogo(JFrame window) {
        try {
            window.setIconImage(logoImage);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void setLogo(JDialog window) {
        try {
            window.setIconImage(logoImage);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void setLook(int look) {
        try {
            if (look == 0) {
                UIManager.setLookAndFeel("de.muntjak.tinylookandfeel.TinyLookAndFeel");
            } else if (look == 1) {
                UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
            } else {
                UIManager.setLookAndFeel("javax.swing.plaf.metal.MetalLookAndFeel");
            }
            SwingUtilities.updateComponentTreeUI(frame);
            frame.repaint();
            frame.validate();
            frame.pack();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    static {
        tableColumns = new String[]{"File", "New Name"};
    }

    private static class ListenerHelpForum
    implements ActionListener {
        private ListenerHelpForum() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                URI url = new URI("http://www.stormhyde.com/forum/");
                Desktop desktop = Desktop.getDesktop();
                desktop.browse(url);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    private static class ListenerHelpWebsite
    implements ActionListener {
        private ListenerHelpWebsite() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                URI url = new URI("http://www.stormhyde.com/image-renamer/");
                Desktop desktop = Desktop.getDesktop();
                desktop.browse(url);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    private static class ListenerHelpDonate
    implements ActionListener {
        private ListenerHelpDonate() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                URI url = new URI("http://www.stormhyde.com/donate/");
                Desktop desktop = Desktop.getDesktop();
                desktop.browse(url);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    private static class ListenerHelpAbout
    implements ActionListener {
        private ListenerHelpAbout() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JDialog about = new JDialog(frame);
            JPanel aboutPanel = new JPanel(new GridLayout(2, 1, padX, padY));
            String aboutText1 = "<html><body style=\"color:#FFFFFF\"><center><a>www.<b>stormhyde</b>.com</a><br /><br /><a>Developed by <a>Hayden Barnett</a></a><br /><a>www.<b>haydenbarnett</b>.net</a><br /><br /><a>Featuring graphics by <a>Gavin Barnett</a></a><br /><a>www.<b>gavinbarnett</b>.net</a></center></body></html>";
            JLabel jlblAbout1 = new JLabel(aboutText1);
            jlblAbout1.setVerticalAlignment(1);
            jlblAbout1.setHorizontalAlignment(0);
            aboutPanel.add(jlblaboutImage);
            aboutPanel.add(jlblAbout1);
            about.add(aboutPanel);
            about.setSize(640, 350);
            about.setTitle("About");
            aboutPanel.setBackground(Color.BLACK);
            about.setDefaultCloseOperation(2);
            about.setLocationRelativeTo(null);
            about.setResizable(false);
            RenamerGUI.setLogo(about);
            about.setVisible(true);
        }
    }

    private static class ListenerEditLook1
    implements ActionListener {
        private ListenerEditLook1() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            RenamerGUI.setLook(1);
        }
    }

    private static class ListenerEditLook0
    implements ActionListener {
        private ListenerEditLook0() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            RenamerGUI.setLook(0);
        }
    }

    private static class ListenerEditUndo
    implements ActionListener {
        private ListenerEditUndo() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JOptionPane.showMessageDialog(frame, "This feature is coming soon!", "Error", 2);
        }
    }

    private static class ListenerFileExit
    implements ActionListener {
        private ListenerFileExit() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            System.exit(0);
        }
    }

    private static class ListenerOrder
    implements ItemListener {
        private ListenerOrder() {
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            RenamerGUI.loadFiles();
        }
    }

    class customTable
    extends JTable {
        customTable() {
        }

        public Class getColumnClass(int column) {
            try {
                if (column == 5) {
                    return Class.forName("java.lang.Boolean");
                }
                return Class.forName("java.lang.Object");
            }
            catch (Exception ex) {
                ex.printStackTrace();
                return null;
            }
        }
    }

    private static class ListenerRename
    implements ActionListener {
        private ListenerRename() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (JOptionPane.showConfirmDialog(null, "Rename these files?", "Renaming", 0) == 0) {
                if (tableModel.getRowCount() > 0) {
                    String path = jtfDirectory.getText();
                    if (path.substring(path.length()) != "/") {
                        path = path + "/";
                    }
                    boolean errors = false;
                    for (int i = 0; i < tableModel.getRowCount(); ++i) {
                        File newFile;
                        File oldFile = new File(path + (String)tableModel.getValueAt(i, 0));
                        boolean success = oldFile.renameTo(newFile = new File(path + (String)tableModel.getValueAt(i, 1)));
                        if (success) continue;
                        errors = true;
                    }
                    if (errors) {
                        JOptionPane.showMessageDialog(frame, "An error occured", "Error", 2);
                    } else {
                        JOptionPane.showMessageDialog(frame, "Rename successful!", "Success", 1);
                    }
                } else {
                    JOptionPane.showMessageDialog(frame, "Found no files to rename...", "Error", 2);
                }
            } else {
                System.out.println("Cancelled");
            }
        }
    }

    public static class Comparator2
    implements Comparator<File> {
        @Override
        public int compare(File f1, File f2) {
            return Long.valueOf(f1.lastModified()).compareTo(f2.lastModified());
        }
    }

    public static class Comparator1
    implements Comparator<File> {
        @Override
        public int compare(File f1, File f2) {
            return Long.valueOf(f1.lastModified()).compareTo(f2.lastModified());
        }
    }

    private static class ListenerChangeDirectory
    implements DocumentListener {
        private ListenerChangeDirectory() {
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            this.updateLog(e, "");
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            this.updateLog(e, "");
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
        }

        public void updateLog(DocumentEvent e, String action) {
            RenamerGUI.loadFiles();
        }
    }

    private static class ListenerOpenDirectory
    implements ActionListener {
        private ListenerOpenDirectory() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JFileChooser pathChooser = new JFileChooser(jtfDirectory.getText());
            pathChooser.setDialogTitle("Select Source Directory");
            pathChooser.setFileSelectionMode(2);
            pathChooser.setAcceptAllFileFilterUsed(true);
            int returnVal = pathChooser.showDialog(frame, "Open");
            if (returnVal == 0) {
                try {
                    if (pathChooser.getSelectedFile().isDirectory()) {
                        jtfDirectory.setText(pathChooser.getSelectedFile().getAbsolutePath());
                    } else {
                        jtfDirectory.setText(pathChooser.getSelectedFile().getParent());
                    }
                }
                catch (Exception ex) {
                    // empty catch block
                }
            }
        }
    }
}

